<?php

error_reporting(0);
set_time_limit(0);

$upload_token = $_GET['token'];
$file_info = pathinfo($_FILES['msk']['name']);
$file_extension = $file_info['extension'];
$uploads_dir = 'u/';

// Read data from tokens.json file
$json_file_path = 'data/tokens.json';
$json_content = file_get_contents($json_file_path);

if ($json_content === false) {
    echo "error_tokens";
    exit;
}

$json_data = json_decode($json_content, true);
$token_data = null;

foreach ($json_data as $item) {
    if ($item['token'] == $upload_token) {
        $token_data = $item;
        break;
    }
}

if ($token_data === null) {
    echo "invalid_token";
    exit;
}

$max_file_size_MB = $token_data['maxSize'];
$max_file_size = $max_file_size_MB * 1024 * 1024;

if ($_FILES['msk']['size'] > $max_file_size) {
    echo "invalid_size";
    exit;
}

if (is_uploaded_file($_FILES['msk']['tmp_name'])) {
    if (!file_exists($uploads_dir)) {
        mkdir($uploads_dir);
    }

    $current_datetime = new DateTime('now', new DateTimeZone('Asia/Tehran'));
    $current_date_time = $current_datetime->format('YmdHis');
    
    $prefix = '';
    if (in_array($file_extension, $token_data['allowedFormats'])) {
        if (in_array($file_extension, ['jpg', 'jpeg', 'png', 'gif'])) {
            $prefix = 'IMG_';
        } elseif (in_array($file_extension, ['mp4', 'avi', 'mov', 'mkv'])) {
            $prefix = 'VID_';
        } else {
            $prefix = 'DOC_';
        }
    }

    $new_file_name = $prefix . $current_date_time . '.' . $file_extension;
    $full_file_path = $uploads_dir . $new_file_name;
    $url = "https://bangtanstar.ir/GbGram/api/u/" . $new_file_name;

    if (in_array($file_extension, $token_data['allowedFormats'])) {
        $tmp_name = $_FILES['msk']['tmp_name'];

        move_uploaded_file($tmp_name, $full_file_path);

        echo $url;
    } else {
        echo "invalid_format";
    }
} else {
    echo "failed";
}
?>