<?php

error_reporting(0);
set_time_limit(0);

include 'db.php';
include 'data/time.php';

date_default_timezone_set('Asia/Tehran');

$hash = $_POST['hash'];
$code = $_POST['code'];
$device = $_POST['device'];

if (empty($device)) {
    $response = ['status' => 'error', 'message' => 'empty device'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// ✅ تغییر: اگر کد 00000 باشد، هر hashی معتبر تلقی شود
if ($code === '00000') {
    // فرض کنیم کاربر وجود دارد (یا ایجاد کنیم)
    $stmt = $pdo->prepare("SELECT * FROM users WHERE hash_rec = :hash");
    $stmt->execute(['hash' => $hash]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        // اگر کاربر وجود نداشت، ایجاد کن
        $currentTime = time();
        $verificationCode = '00000'; // کد مجاز
        $guid = generate_uuid();

        $stmt = $pdo->prepare('INSERT INTO users (number, ip, code, now_timestamp, expiry_timestamp, hash_rec, guid) VALUES (?, ?, ?, ?, ?, ?, ?)');
        $stmt->execute([
            '09123456789', // شماره نمونه
            $_SERVER['REMOTE_ADDR'],
            $verificationCode,
            $currentTime,
            $currentTime + (2 * 60),
            $hash,
            $guid
        ]);

        $user = $pdo->lastInsertId();
        $user = [
            'id' => $user,
            'number' => '09123456789',
            'ip' => $_SERVER['REMOTE_ADDR'],
            'code' => $verificationCode,
            'now_timestamp' => $currentTime,
            'expiry_timestamp' => $currentTime + (2 * 60),
            'hash_rec' => $hash,
            'guid' => $guid,
            'color' => rand(1, 5),
            'ban' => 0,
            'blue_tick' => 0,
            'developer' => 0,
            'bio' => "سلام ! این یک بیوگرافی تست است",
            'name' => "بدون نام",
            'last_seen' => time()
        ];
    }
} else {
    // ❌ اگر کد غیر 00000 باشد، همانطور که بود (بررسی واقعی)
    $stmt = $pdo->prepare("SELECT * FROM users WHERE hash_rec = :hash");
    $stmt->execute(['hash' => $hash]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        $response = ['status' => 'error', 'message' => 'invalid hash'];
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit();
    }

    if ($user['code'] !== $code) {
        $response = ['status' => 'error', 'message' => 'invalid code'];
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit();
    }

    if (time() > $user['expiry_timestamp']) {
        $response = ['status' => 'error', 'message' => 'expired code'];
        echo json_encode($response, JSON_UNESCAPED_UNICODE);
        exit();
    }
}

    $uuid = generate_uuid();
    if (empty($user['guid'])) {
        $user['guid'] = $uuid;
    }

    $defaultValues = [
        'color' => rand(1, 5),
        'ban' => 0,
        'blue_tick' => 0,
        'developer' => 0,
        'bio' => "سلام ! این یک بیوگرافی تست است",
        'name' => "بدون نام",
        'last_seen' => $currentPersianDate
    ];

    foreach ($defaultValues as $key => $value) {
        if (empty($user[$key])) {
            $user[$key] = $value;
        }
    }

    $newAuth = generateRandomString(32);

    // بررسی وجود دستگاه
    $stmt = $pdo->prepare("SELECT * FROM devices WHERE user_id = :user_id AND device = :device");
    $stmt->execute(['user_id' => $user['id'], 'device' => $device]);
    $existingDevice = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($existingDevice) {
        // به‌روزرسانی دستگاه
$stmt = $pdo->prepare("UPDATE devices SET date = :date, ip = :ip WHERE id = :id AND auth = :auth");
$stmt->execute([
    'date' => $currentPersianDate,
    'ip' => $_SERVER['REMOTE_ADDR'],
    'id' => $existingDevice['id'],
    'auth' => $existingDevice['auth']
]); 
$oldAuth= $existingDevice['auth'];
$test_user ='old';
    } else {
        // اضافه کردن دستگاه جدید
        $stmt = $pdo->prepare("INSERT INTO devices (user_id, platform, auth, device, date, ip) VALUES (:user_id, 'android', :auth, :device, :date, :ip)");
        $stmt->execute([
            'user_id' => $user['id'],
            'auth' => $newAuth,
            'device' => $device,
            'date' => $currentPersianDate,
            'ip' => $_SERVER['REMOTE_ADDR']
        ]);
                $test_user ='new';
    }

    $stmt = $pdo->prepare("
        UPDATE users SET
            guid = :guid,
            color = :color,
            ban = :ban,
            blue_tick = :blue_tick,
            developer = :developer,
            bio = :bio,
            name = :name,
            last_seen = :last_seen
        WHERE id = :id
    ");
    $stmt->execute([
        'guid' => $user['guid'],
        'color' => $user['color'],
        'ban' => $user['ban'],
        'blue_tick' => $user['blue_tick'],
        'developer' => $user['developer'],
        'bio' => $user['bio'],
        'name' => $user['name'],
        'last_seen' => time(),
        'id' => $user['id']
    ]);

    if ($test_user === 'old'){
    $response = ['status' => 'ok', 'message' => 'login success', 'auth' => $oldAuth, 'guid' => $user['guid']];
    } else {
        $response = ['status' => 'ok', 'message' => 'login success', 'auth' => $newAuth, 'guid' => $user['guid']];
     } 
     
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();

function generate_uuid() {
    $random_bytes = random_bytes(16);
    $random_bytes[6] = chr(ord($random_bytes[6]) & 0x0f | 0x40);
    $random_bytes[8] = chr(ord($random_bytes[8]) & 0x3f | 0x80);
    $uuid = bin2hex($random_bytes);
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split($uuid, 4));
}

function generateRandomString($length) {
    $characters = 'abcdefghijklmnopqrstuvwxyz';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
?>