<?php
error_reporting(0);
set_time_limit(0);

include 'db.php';
include 'db2.php';
include 'data/time.php';
date_default_timezone_set('Asia/Tehran');

function generate_uuid() {
    $random_bytes = random_bytes(8);
    $random_bytes[0] = chr(ord($random_bytes[0]) & 0x0f | 0x40);
    $random_bytes[1] = chr(ord($random_bytes[1]) & 0x3f | 0x80);
    return substr(bin2hex($random_bytes), 0, 15);
}

$auth = $_POST['auth'];
$recipientGuid = $_POST['guid'];
$text = $_POST['text'];
$file = $_POST['file'] ?? "false";

if (empty($auth) || empty($recipientGuid)) {
    $response = ['status' => 'error', 'message' => 'Missing required fields'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

$stmt = $pdo->prepare("
    SELECT u.id AS user_id, u.guid, u.ban, u.name
    FROM users u 
    INNER JOIN devices d ON u.id = d.user_id 
    WHERE d.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$firstUser = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$firstUser) {
    $response = ['status' => 'error', 'message' => 'Invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if ($firstUser['ban'] === '1') {
    $response = ['status' => 'error', 'message' => 'baned account'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

$stmt = $pdo->prepare("SELECT id AS user_id FROM users WHERE guid = :guid");
$stmt->execute(['guid' => $recipientGuid]);
$secondUser = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$secondUser) {
    $response = ['status' => 'error', 'message' => 'Recipient not found'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// formats
$imageFormats = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];
$audioFormats = ['mp3', 'wav', 'ogg', 'aac', 'flac'];
$videoFormats = ['mp4', 'avi', 'mkv', 'mov', 'flv', 'wmv'];

$fileType = "unknown";
if ($file !== "false") {
    $fileInfo = pathinfo($file);
    $extension = strtolower($fileInfo['extension'] ?? "");

    if (in_array($extension, $imageFormats)) {
        $fileType = "image";
    } elseif (in_array($extension, $audioFormats)) {
        $fileType = "audio";
    } elseif (in_array($extension, $videoFormats)) {
        $fileType = "video";
    }
}

// Create table for chat
function createChatTablesIfNotExist($pdo2, $firstUserId, $secondUserId) {
    $table1 = "chat_{$firstUserId}_{$secondUserId}";
    $query1 = "CREATE TABLE IF NOT EXISTS `$table1` (
        `id` VARCHAR(15) PRIMARY KEY,
        `file` TEXT,
        `fileType` VARCHAR(20),
        `text` TEXT,
        `reply` VARCHAR(15),
        `edited` VARCHAR(5),
        `position` VARCHAR(15),
        `pinned` VARCHAR(5) DEFAULT 'false',
        `timestamp` BIGINT,
        `date` VARCHAR(255),
        `time` VARCHAR(255),
        `seen` VARCHAR(5),
        `user_id` INT NOT NULL DEFAULT 1
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $pdo2->exec($query1);

    if ($firstUserId !== $secondUserId) {
        $table2 = "chat_{$secondUserId}_{$firstUserId}";
        $query2 = "CREATE TABLE IF NOT EXISTS `$table2` (
            `id` VARCHAR(15) PRIMARY KEY,
            `file` TEXT,
            `fileType` VARCHAR(20),
            `text` TEXT,
            `reply` VARCHAR(15),
            `edited` VARCHAR(5),
            `position` VARCHAR(15),
            `pinned` VARCHAR(5) DEFAULT 'false',
            `timestamp` BIGINT,
            `date` VARCHAR(255),
            `time` VARCHAR(255),
            `seen` VARCHAR(5),
            `user_id` INT NOT NULL DEFAULT 2
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
        $pdo2->exec($query2);
    }
}

createChatTablesIfNotExist($pdo2, $firstUser['user_id'], $secondUser['user_id']);

// Create message
$id = generate_uuid();
$timestamp = time(); // Get current timestamp

// Use jdatetime for date and time
$shamsiDateTime = new jDateTime(true, true, 'Asia/Tehran');
$date = $shamsiDateTime->date('Y/m/d/H/i/s');
$time = $shamsiDateTime->date('H:i');

// Prepare message object
$messageObject = [
    'id' => $id,
    'file' => $file,
    'fileType' => $fileType,
    'text' => $text,
    'reply' => $_POST['reply'] ?? "false",
    'edited' => "false",
    'position' => $_POST['position'] ?? "false",
    'timestamp' => $timestamp, // Add timestamp here
    'date' => $date, // Add date here
    'time' => $time, // Add time here
    'seen' => "false",
];

// Send in table
$table1 = "chat_{$firstUser['user_id']}_{$secondUser['user_id']}";
$stmt = $pdo2->prepare("
    INSERT INTO `$table1` (id, file, fileType, text, reply, edited, position, timestamp, date, time, seen, user_id) 
    VALUES (:id, :file, :fileType, :text, :reply, :edited, :position, :timestamp, :date, :time, :seen, 1)
");
$stmt->execute($messageObject);

if ($firstUser['user_id'] !== $secondUser['user_id']) {
    $table2 = "chat_{$secondUser['user_id']}_{$firstUser['user_id']}";
    $stmt = $pdo2->prepare("
        INSERT INTO `$table2` (id, file, fileType, text, reply, edited, position, timestamp, date, time, seen, user_id) 
        VALUES (:id, :file, :fileType, :text, :reply, :edited, :position, :timestamp, :date, :time, :seen, 2)
    ");
    $stmt->execute($messageObject);
}

$response = ['status' => 'ok', 'message' => 'sent'];
echo json_encode($response, JSON_UNESCAPED_UNICODE); 
?>