<?php
error_reporting(0);
set_time_limit(0);

require 'db.php';

function generateVerificationCode() {
    return rand(10000, 99999);
}

function generateRandomNumber($length) {
    $characters = '0123456789';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}

// ❌ حذف تابع sendVerificationCode و جایگزینی با یک پاسخ مصنوعی
function sendVerificationCode($number, $verificationCode, $hash_rec) {
    // به جای ارسال واقعی، فقط یک پاسخ موفقیت‌آمیز بده
    $output = ['status' => 'ok', 'message' => 'code sent successfully', 'hash' => $hash_rec];
    echo json_encode($output, JSON_UNESCAPED_UNICODE);
    exit();
}

$hash_rec = generateRandomNumber(42);
$number = $_POST['number'];

if (substr($number, 0, 2) !== "09") {
    $output = ['status' => 'error', 'message' => 'invalid number'];
    echo json_encode($output, JSON_UNESCAPED_UNICODE);
    exit();
}

if (!empty($number)) {
    $currentTime = time();

    $stmt = $pdo->prepare('SELECT * FROM users WHERE number = ?');
    $stmt->execute([$number]);
    $user = $stmt->fetch();

    if ($user) {
        if ($user['ban'] == '1') {
            $response = ['status' => 'error', 'message' => 'baned account'];
            echo json_encode($response, JSON_UNESCAPED_UNICODE);
            exit();
        }

        $timeDiff = $currentTime - $user['now_timestamp'];
        if ($timeDiff < (2 * 60)) {
            $response = ['status' => 'error', 'message' => 'try again later'];
            echo json_encode($response, JSON_UNESCAPED_UNICODE);
            exit();
        } else {
            // older users
            $verificationCode = generateVerificationCode();
            $stmt = $pdo->prepare('UPDATE users SET ip = ?, code = ?, now_timestamp = ?, expiry_timestamp = ?, hash_rec = ? WHERE number = ?');
            $stmt->execute([$_SERVER['REMOTE_ADDR'], $verificationCode, $currentTime, $currentTime + (2 * 60), $hash_rec, $number]);

            // ✅ فقط پاسخ موفقیت‌آمیز بده (بدون ارسال واقعی)
            sendVerificationCode($number, $verificationCode, $hash_rec);
            exit();
        }
    } else {
        // new users
        $verificationCode = generateVerificationCode();
        $stmt = $pdo->prepare('INSERT INTO users (number, ip, code, now_timestamp, expiry_timestamp, hash_rec) VALUES (?, ?, ?, ?, ?, ?)');
        $stmt->execute([$number, $_SERVER['REMOTE_ADDR'], $verificationCode, $currentTime, $currentTime + (2 * 60), $hash_rec]);

        // ✅ فقط پاسخ موفقیت‌آمیز بده
        sendVerificationCode($number, $verificationCode, $hash_rec);
        exit();
    }
} else {
    $response = ['status' => 'error', 'message' => 'invalid number'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
}
?>