<?php
error_reporting(0);
set_time_limit(0);

include 'db.php';
include 'db2.php';
include 'data/time.php';
date_default_timezone_set('Asia/Tehran');

function encrypt($password, $message) {
    $ivBytes = hex2bin('00000000000000000000000000000000');
    $key = hash('sha256', $password, true);
    $cipherText = openssl_encrypt($message, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $ivBytes);
    return base64_encode($cipherText);
}

$persianMonths = [
    "فروردین", "اردیبهشت", "خرداد", "تیر", "مرداد", "شهریور",
    "مهر", "آبان", "آذر", "دی", "بهمن", "اسفند"
];

function convertPersianToEnglish($string) {
    $persianNumbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $englishNumbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    return str_replace($persianNumbers, $englishNumbers, $string);
}

function formatPersianDate($date) {
    global $persianMonths;
    list($year, $month, $day) = explode("/", $date);
    $monthName = $persianMonths[$month - 1];
    return "{$day} {$monthName}";
}

$auth = $_POST['auth'];
$guid2 = $_POST['guid'];

$stmt = $pdo->prepare("
    SELECT u.id AS user_id, u.guid, u.ban 
    FROM users u 
    INNER JOIN devices d ON u.id = d.user_id 
    WHERE d.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid auth'], JSON_UNESCAPED_UNICODE);
    exit();
}

if ($user['ban'] === '1') {
    echo json_encode(['status' => 'error', 'message' => 'blocked account'], JSON_UNESCAPED_UNICODE);
    exit();
}

if (empty($auth) || empty($guid2)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid auth or guid'], JSON_UNESCAPED_UNICODE);
    exit();
}

try {
    $stmt = $pdo->prepare('
        SELECT u.id, u.guid, u.name, u.color, u.last_seen
        FROM users u
        JOIN devices d ON u.id = d.user_id
        WHERE d.auth = :auth
    ');
    $stmt->execute(['auth' => $auth]);
    $userData1 = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$userData1) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid auth'], JSON_UNESCAPED_UNICODE);
        exit();
    }

    $guid1 = $userData1['guid'];
    $user1_id = $userData1['id'];

    $stmt = $pdo->prepare('
        SELECT id, guid, name, color, last_seen
        FROM users
        WHERE guid = :guid
    ');
    $stmt->execute(['guid' => $guid2]);
    $user89 = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user89) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid guid'], JSON_UNESCAPED_UNICODE);
        exit();
    }

    $user2_id = $user89['id'];
    $chatTable = "chat_{$user1_id}_{$user2_id}";
    $otherChatTable = "chat_{$user2_id}_{$user1_id}";
    $pinnedMessage = false;
    $chatMessages = [];

    try {
        $pdo2->prepare("UPDATE $otherChatTable SET seen = 'true'")->execute();
        $stmt = $pdo2->prepare("SELECT * FROM $chatTable ORDER BY timestamp ASC");
        $stmt->execute();
        $chatMessages = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $stmt = $pdo2->prepare("SELECT * FROM $chatTable WHERE pinned = 'true' ORDER BY timestamp DESC LIMIT 1");
        $stmt->execute();
        $pinnedMessage = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $chatMessages = [];
    }

    $onlineStatus = (time() - $user89['last_seen'] <= 10) ? "true" : "false";

    $processedMessages = [];
    $lastDate = "";
    $shamsiDateTime = new jDateTime(true, true, 'Asia/Tehran');
    $todayPersianDate = $shamsiDateTime->date('Y/m/d');
    $todayPersianDate = convertPersianToEnglish($todayPersianDate);

    foreach ($chatMessages as $message) {
        $message['user_id'] = (string) $message['user_id'];
        $message['date'] = convertPersianToEnglish($message['date']);
        $messageDateParts = explode("/", $message['date']);
        $formattedDate = implode("/", array_slice($messageDateParts, 0, 3));

        if ($formattedDate === $todayPersianDate) {
            $formattedDate = "امروز";
        } else {
            $formattedDate = formatPersianDate($formattedDate);
        }

        if ($formattedDate !== $lastDate) {
            $processedMessages[] = [
                "type" => "date",
                "date" => $formattedDate
            ];
            $lastDate = $formattedDate;
        }

        $message['type'] = "chat";
        $message['replyText'] = "null";
        $message['replyFile'] = "null";
        $message['replyName'] = "null";
        $message['replyPos'] = "null";

        if (isset($message['reply']) && !empty($message['reply'])) {
            $replyId = $message['reply'];
            
            // جستجو در هر دو جدول با اولویت جدول فعلی
            $replyStmt = $pdo2->prepare("SELECT * FROM $chatTable WHERE id = :replyId");
            $replyStmt->execute(['replyId' => $replyId]);
            $replyMessage = $replyStmt->fetch(PDO::FETCH_ASSOC);

            if (!$replyMessage) {
                $replyStmt = $pdo2->prepare("SELECT * FROM $otherChatTable WHERE id = :replyId");
                $replyStmt->execute(['replyId' => $replyId]);
                $replyMessage = $replyStmt->fetch(PDO::FETCH_ASSOC);
            }

            if ($replyMessage) {
                $message['replyText'] = $replyMessage['text'] ?? "null";
                $message['replyFile'] = $replyMessage['file'] ?? "null";
                $message['replyPos'] = $replyMessage['position'] ?? "null";
                
                // تشخیص صحیح کاربر بر اساس جدول مبدا
                if (strpos($chatTable, "chat_{$user1_id}_{$user2_id}") !== false) {
                    // اگر در جدول کاربر اول هستیم
                    $replyUserId = ($replyMessage['user_id'] == 1) ? $user1_id : $user2_id;
                } else {
                    // اگر در جدول کاربر دوم هستیم
                    $replyUserId = ($replyMessage['user_id'] == 1) ? $user2_id : $user1_id;
                }
                
                $replyUserStmt = $pdo->prepare("SELECT name FROM users WHERE id = :user_id");
                $replyUserStmt->execute(['user_id' => $replyUserId]);
                $replyUser = $replyUserStmt->fetch(PDO::FETCH_ASSOC);

                if ($replyUser) {
                    $message['replyName'] = $replyUser['name'];
                }
            }
        }

        $processedMessages[] = $message;
    }

    $outputArray = [
        'online' => $onlineStatus,
        'chat' => json_encode($processedMessages),
        'pinned' => $pinnedMessage
    ];

    $encryptedText = encrypt($auth, json_encode($outputArray, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    echo json_encode([
        'status' => 'ok',
        'message' => 'success',
        'data' => $encryptedText,
        'pinned' => $pinnedMessage
    ], JSON_UNESCAPED_UNICODE);
} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>