<?php
error_reporting(0);
set_time_limit(0);

include 'db.php'; // اتصال به دیتابیس

$auth = $_POST['auth'];
$profile = $_POST['profile']; // پروفایل جدید از طریق درخواست POST دریافت می‌شود

$stmt = $pdo->prepare("
    SELECT u.id AS user_id, u.guid, u.ban
    FROM users u
    INNER JOIN devices d ON u.id = d.user_id
    WHERE d.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$firstUser = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$firstUser) {
    $response = ['status' => 'error', 'message' => 'Invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if ($firstUser['ban'] === '1') {
    $response = ['status' => 'error', 'message' => 'baned account'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// جستجو برای کاربر در جدول devices با استفاده از auth
$stmt = $pdo->prepare("
    SELECT users.* FROM users
    JOIN devices ON devices.user_id = users.id
    WHERE devices.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    // به‌روزرسانی پروفایل کاربر
    $stmt = $pdo->prepare("UPDATE users SET profile = :profile WHERE id = :id");
    $stmt->execute([
        'profile' => $profile,
        'id' => $user['id']
    ]);

    // بررسی موفقیت‌آمیز بودن به‌روزرسانی
    if ($stmt->rowCount() > 0) {
        $response = ['status' => 'ok', 'message' => 'profile updated'];
    } else {
        $response = ['status' => 'error', 'message' => 'no changes made to profile'];
    }

    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
} else {
    $response = ['status' => 'error', 'message' => 'invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
}

?>