<?php
error_reporting(0);
set_time_limit(0);
include 'db.php';
include 'db2.php';

$auth = $_POST['auth'];
$id = $_POST['id'];
$recipientGuid = $_POST['guid'];
$deleteFor = $_POST['deleteFor'] ?? 0;

if (empty($auth) || empty($id) || empty($recipientGuid)) {
    $response = ['status' => 'error', 'message' => 'Missing required fields'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// Fetch first user details with auth
$stmt = $pdo->prepare("
    SELECT u.id AS user_id, u.guid, u.ban
    FROM users u
    INNER JOIN devices d ON u.id = d.user_id
    WHERE d.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$firstUser = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$firstUser) {
    $response = ['status' => 'error', 'message' => 'Invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if ($firstUser['ban'] === '1') {
    $response = ['status' => 'error', 'message' => 'Blocked account'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// Fetch recipient details with guid
$stmt = $pdo->prepare("SELECT id AS user_id FROM users WHERE guid = :guid");
$stmt->execute(['guid' => $recipientGuid]);
$secondUser = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$secondUser) {
    $response = ['status' => 'error', 'message' => 'Recipient not found'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

// Identify the chat tables
$table1 = "chat_{$firstUser['user_id']}_{$secondUser['user_id']}";
$table2 = "chat_{$secondUser['user_id']}_{$firstUser['user_id']}";

try {
    // Delete from the sender's table
    $stmt = $pdo2->prepare("DELETE FROM `$table1` WHERE id = :id");
    $stmt->execute(['id' => $id]);

    // If deleteFor == 1, delete from the recipient's table as well
    if ($deleteFor == "1") {
        $stmt = $pdo2->prepare("DELETE FROM `$table2` WHERE id = :id");
        $stmt->execute(['id' => $id]);
    }

    $response = ['status' => 'ok', 'message' => 'success'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    $response = ['status' => 'error', 'message' => 'Error deleting message'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
}
?>