<?php
error_reporting(0);
set_time_limit(0);

include 'db.php';
include 'db2.php'; // برای اتصال به دیتابیس دوم

$auth = $_POST['auth'];
$guid2 = $_POST['guid'];

$stmt = $pdo->prepare("
    SELECT u.id AS user_id, u.guid, u.ban
    FROM users u
    INNER JOIN devices d ON u.id = d.user_id
    WHERE d.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$firstUser = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$firstUser) {
    $response = ['status' => 'error', 'message' => 'Invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if ($firstUser['ban'] === '1') {
    $response = ['status' => 'error', 'message' => 'baned account'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

if (empty($auth) || empty($guid2)) {
    $response = ['status' => 'error', 'message' => 'Missing required fields'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

$stmt = $pdo->prepare("
    SELECT u.guid, u.id 
    FROM users u 
    INNER JOIN devices d ON u.id = d.user_id 
    WHERE d.auth = :auth
");
$stmt->execute(['auth' => $auth]);
$firstUser = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$firstUser) {
    $response = ['status' => 'error', 'message' => 'Invalid auth'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

$user1Id = $firstUser['id'];

// استخراج id کاربر دوم
$stmt = $pdo->prepare("SELECT id FROM users WHERE guid = :guid");
$stmt->execute(['guid' => $guid2]);
$secondUser = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$secondUser) {
    $response = ['status' => 'error', 'message' => 'Second user not found'];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit();
}

$user2Id = $secondUser['id'];

// نام جدول چت
$tableName = "chat_{$user1Id}_{$user2Id}";

// حذف جدول چت در دیتابیس دوم
$stmt = $pdo2->prepare("DROP TABLE IF EXISTS $tableName");
$stmt->execute();

$response = ['status' => 'ok', 'message' => 'Chat table deleted successfully'];
echo json_encode($response, JSON_UNESCAPED_UNICODE);
?>